<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'Form Berita') ?></title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">
  
  <style>
    .sidebar { width: 280px; min-height: 100vh; overflow-y: auto; }
    .sidebar a { text-decoration: none; }
    .sidebar .active { background: rgba(13,110,253,.12); border-radius: .5rem; }
    .sub-menu { padding-left: 1rem; }
    .sub-menu .list-group-item {
      font-size: 0.9rem;
      padding: 0.5rem 1rem;
      border: none;
    }
    .menu-toggle {
      cursor: pointer;
      position: relative;
    }
    .menu-toggle::after {
      content: '▼';
      position: absolute;
      right: 1rem;
      font-size: 0.75rem;
      transition: transform 0.3s;
    }
    .menu-toggle.collapsed::after {
      transform: rotate(-90deg);
    }
    body { background: #f6f8fb; }
    .page-wrap { max-width: 980px; }
    .hero-title { letter-spacing: .2px; }
    .soft-card {
      border: 0;
      border-radius: 18px;
      box-shadow: 0 10px 30px rgba(16, 24, 40, .08);
    }
    .hint { color: #667085; font-size: .9rem; }
    .main-content { flex: 1; }
    
    label {
      display: block;
      font-weight: 600;
      font-size: 14px;
      color: #344054;
      margin: 0 0 8px 0;
    }
    
    input[type="text"], 
    input[type="date"],
    input[type="file"],
    textarea {
      width: 100%;
      padding: 12px 14px;
      border: 1px solid #d0d5dd;
      border-radius: 14px;
      background: #fff;
      font-size: 14px;
      color: #1f2937;
      transition: all 0.2s;
    }
    
    input[type="text"]::placeholder,
    textarea::placeholder {
      color: #9ca3af;
    }
    
    input[type="text"]:focus,
    input[type="date"]:focus,
    textarea:focus {
      outline: none;
      border-color: #2563eb;
      box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
    }
    
    input[type="file"] {
      padding: 10px 14px;
      cursor: pointer;
      font-size: 13px;
    }
    
    .form-group {
      margin-bottom: 20px;
    }
    
    .preview-wrapper {
      margin-top: 14px;
      padding: 14px;
      background: #f9fafb;
      border-radius: 12px;
      border: 1px solid #e5e7eb;
    }
    
    .preview-label {
      font-size: 13px;
      color: #667085;
      margin: 0 0 10px 0;
    }
    
    img.preview {
      border-radius: 10px;
      border: 1px solid #e5e7eb;
      max-width: 100%;
      display: block;
      background: #fff;
      max-height: 200px;
      object-fit: contain;
    }
    
    .checkbox-wrapper {
      display: flex;
      align-items: center;
      gap: 10px;
      padding: 12px 16px;
      background: #f9fafb;
      border: 1px solid #e5e7eb;
      border-radius: 12px;
    }
    
    .checkbox-wrapper input[type="checkbox"] {
      width: 20px;
      height: 20px;
      cursor: pointer;
    }
    
    .checkbox-wrapper label {
      margin: 0;
      cursor: pointer;
      font-weight: 600;
    }
    
    .btn {
      padding: 12px 24px;
      border-radius: 999px;
      font-weight: 600;
      font-size: 14px;
      transition: all 0.2s;
      border: none;
    }
    
    .btn-primary {
      background: #2563eb;
      color: #fff;
    }
    
    .btn-primary:hover {
      background: #1d4ed8;
      transform: translateY(-1px);
      box-shadow: 0 4px 12px rgba(37, 99, 235, 0.25);
    }
    
    .btn-secondary {
      background: #fff;
      color: #344054;
      border: 2px solid #d0d5dd;
    }
    
    .btn-secondary:hover {
      background: #f9fafb;
    }
    
    .alert-danger {
      background: #fee2e2;
      color: #991b1b;
      padding: 14px 16px;
      border-radius: 12px;
      margin-bottom: 24px;
      border: 1px solid #fecaca;
      font-size: 14px;
    }
    
    .alert-danger ul {
      margin: 0.5rem 0 0 1.5rem;
      padding: 0;
    }
    /* ===== TAMBAHAN RESPONSIVE (AMAN) ===== */
    .hamburger {
      display: none;
      font-size: 1.6rem;
      color: #fff;
      cursor: pointer;
    }

    .sidebar-overlay {
      display: none;
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,.45);
      z-index: 1040;
    }

    @media (max-width: 991px) {
      .hamburger {
        display: block;
      }

      .sidebar {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 1050;
        background: #fff;
        transform: translateX(-100%);
        transition: transform .3s ease;
      }

      .sidebar.show {
        transform: translateX(0);
      }

      .sidebar-overlay.show {
        display: block;
      }
    }
  </style>
</head>

<body class="bg-light">

<nav class="navbar navbar-expand-lg bg-primary navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= site_url('admin') ?>">Welcome back Admin</a>

    <!-- TAMBAHAN: HAMBURGER (TIDAK MENGHAPUS APA PUN) -->
    <span class="hamburger ms-auto me-3" onclick="toggleSidebar()">☰</span>

    <div class="d-flex gap-2 align-items-center">
      <span class="text-white small">Halo, <?= esc(auth()->user()->username ?? 'Admin') ?></span>
      <a class="btn btn-outline-light btn-sm" href="<?= site_url('logout') ?>">Logout</a>
    </div>
  </div>
</nav>

<!-- TAMBAHAN: OVERLAY -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="d-flex">

  <!-- ===== SIDEBAR ASLI KAMU (UTUH, TIDAK DIHAPUS) ===== -->
  <aside class="sidebar bg-white border-end p-3" id="sidebar">
    <div class="fw-bold mb-2">Admin Panel</div>

    <?php
      $uri = service('uri')->getPath();

      $isInfoSekolahActive = ($uri === 'admin' || $uri === 'admin/' ||
                              str_starts_with($uri, 'admin/branding') ||
                              str_starts_with($uri, 'admin/visi-misi') ||
                              str_starts_with($uri, 'admin/kepsek') ||
                              str_starts_with($uri, 'admin/video-profile') ||
                              str_starts_with($uri, 'admin/data-sekolah') ||
                              str_starts_with($uri, 'admin/footer'));

      $isBeritaActive = (str_starts_with($uri, 'admin/berita') ||
                        str_starts_with($uri, 'admin/pengumuman') ||
                        str_starts_with($uri, 'admin/kelulusan') ||
                        str_starts_with($uri, 'admin/kegiatan') ||
                        str_starts_with($uri, 'admin/prestasi'));

      $isGaleriActive = (str_starts_with($uri, 'admin/galeri') ||
                        str_starts_with($uri, 'admin/guru-staf') ||
                        str_starts_with($uri, 'admin/siswa') ||
                        str_starts_with($uri, 'admin/video') ||
                        str_starts_with($uri, 'admin/ekstrakulikuler'));
    ?>

    <div class="list-group list-group-flush">
      <!-- Informasi Sekolah -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isInfoSekolahActive ? '' : 'collapsed' ?> <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
         data-bs-toggle="collapse"
         href="#infoSekolahMenu"
         role="button"
         aria-expanded="<?= $isInfoSekolahActive ? 'true' : 'false' ?>"
         aria-controls="infoSekolahMenu">
        Informasi Sekolah
      </a>

      <div class="collapse <?= $isInfoSekolahActive ? 'show' : '' ?>" id="infoSekolahMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
             href="<?= site_url('admin') ?>">Dashboard</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/visi-misi') ? 'active' : '' ?>"
             href="<?= site_url('admin/visi-misi') ?>">Visi & Misi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kepsek') ? 'active' : '' ?>"
             href="<?= site_url('admin/kepsek') ?>">Kata Sambutan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video-profile') ? 'active' : '' ?>"
             href="<?= site_url('admin/video-profile') ?>">Video Profile</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/data-sekolah') ? 'active' : '' ?>"
             href="<?= site_url('admin/data-sekolah') ?>">Statistika</a>

             <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/footer') ? 'active' : '' ?>"
             href="<?= site_url('admin/footer') ?>">Footer</a>
        </div>
      </div>

      <!-- Berita -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isBeritaActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#beritaMenu"
         role="button"
         aria-expanded="<?= $isBeritaActive ? 'true' : 'false' ?>"
         aria-controls="beritaMenu">
        Berita
      </a>

      <div class="collapse <?= $isBeritaActive ? 'show' : '' ?>" id="beritaMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/pengumuman') ? 'active' : '' ?>"
             href="<?= site_url('admin/pengumuman') ?>">Pengumuman</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kelulusan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kelulusan') ?>">Pengumuman Kelulusan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kegiatan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kegiatan') ?>">Kegiatan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/prestasi') ? 'active' : '' ?>"
             href="<?= site_url('admin/prestasi') ?>">Prestasi</a>
        </div>
      </div>

      <!-- Galeri -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isGaleriActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#galeriMenu"
         role="button"
         aria-expanded="<?= $isGaleriActive ? 'true' : 'false' ?>"
         aria-controls="galeriMenu">
        Galeri
      </a>

      <div class="collapse <?= $isGaleriActive ? 'show' : '' ?>" id="galeriMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/guru-staf') ? 'active' : '' ?>"
             href="<?= site_url('admin/guru-staf') ?>">Guru dan Staf</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/siswa') ? 'active' : '' ?>"
             href="<?= site_url('admin/siswa') ?>">Siswa/Siswi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video') ? 'active' : '' ?>"
             href="<?= site_url('admin/video') ?>">Video</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/ekstrakurikuler') ? 'active' : '' ?>"
             href="<?= site_url('admin/ekstrakurikuler') ?>">Ekstrakulikuler</a>
        </div>
      </div>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/tentang') ? 'active' : '' ?>"
         href="<?= site_url('admin/tentang') ?>">Tentang</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/password') ? 'active' : '' ?>"
         href="<?= site_url('admin/password') ?>">Ubah Password</a>
    </div>
  </aside>



  <!-- Main Content -->
  <div class="main-content">
    <div class="container py-4 page-wrap">

      <!-- Header -->
      <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3 mb-4">
        <div>
          <h1 class="h3 mb-1 hero-title"><?= esc($title ?? 'Form Berita') ?></h1>
          <div class="hint">Isi form untuk menambah atau mengubah berita.</div>
        </div>
      </div>

      <!-- Alert Error -->
      <?php if (!empty($errors)): ?>
        <div class="alert-danger">
          <div class="fw-semibold mb-1">⚠️ Terdapat kesalahan:</div>
          <ul>
            <?php foreach ($errors as $e): ?>
              <li><?= esc($e) ?></li>
            <?php endforeach; ?>
          </ul>
        </div>
      <?php endif; ?>

      <!-- Card -->
      <div class="card soft-card">
        <div class="card-body p-4 p-md-5">

          <form method="post" enctype="multipart/form-data" action="<?= $item
            ? site_url('admin/pengumuman/update/' . $item['id'])
            : site_url('admin/pengumuman/store'); ?>">
            <?= csrf_field() ?>

            <?php if (!empty($item['id'])): ?>
              <input type="hidden" name="id" value="<?= esc($item['id']) ?>">
            <?php endif; ?>

            <!-- Judul -->
            <div class="form-group">
              <label>Judul Berita <span style="color:red;">*</span></label>
              <input type="text" name="judul" value="<?= old('judul', $item['judul'] ?? '') ?>" placeholder="Contoh: Pengumuman PPDB 2025" required>
            </div>

            <!-- Slug -->
            <div class="form-group">
              <label>Slug (Opsional)</label>
              <input type="text" name="slug" value="<?= old('slug', $item['slug'] ?? '') ?>" placeholder="contoh: pengumuman-ppdb-2025">
              <div class="hint mt-2">Boleh dikosongkan. Link detail publik menggunakan ID.</div>
            </div>

            <!-- Ringkasan -->
            <div class="form-group">
              <label>Ringkasan</label>
              <textarea name="ringkasan" rows="3" placeholder="Ringkasan singkat berita..."><?= old('ringkasan', $item['ringkasan'] ?? '') ?></textarea>
              <div class="hint mt-2">Ringkasan singkat yang muncul di card berita.</div>
            </div>

            <!-- Konten -->
            <div class="form-group">
              <label>Konten Lengkap <span style="color:red;">*</span></label>
              <textarea name="konten" rows="8" placeholder="Tulis konten berita lengkap di sini..." required><?= old('konten', $item['konten'] ?? '') ?></textarea>
              <div class="hint mt-2">Konten lengkap berita yang akan ditampilkan di halaman detail.</div>
            </div>

            <!-- Upload Gambar -->
            <div class="form-group">
              <label>Foto / Gambar Berita</label>
              <input type="file" name="gambar" accept="image/*">
              <div class="hint mt-2">Format: JPG, PNG, WEBP (Maks. 2MB). Kosongkan jika tidak ingin mengganti.</div>

              <?php if (!empty($item['gambar'])): ?>
                <div class="preview-wrapper">
                  <div class="preview-label">Gambar saat ini:</div>
                  <img class="preview" src="<?= base_url('uploads/berita/' . $item['gambar']) ?>" alt="Preview">
                </div>
              <?php endif; ?>
            </div>

            <!-- Penulis -->
            <div class="form-group">
              <label>Penulis</label>
              <input type="text" name="penulis" value="<?= old('penulis', $item['penulis'] ?? '') ?>" placeholder="Nama penulis (default: Admin)">
            </div>

            <!-- Tanggal Publish -->
            <div class="form-group">
              <label>Tanggal Publish</label>
              <input type="date" name="tanggal_publish" value="<?= old('tanggal_publish', $item['tanggal_publish'] ?? '') ?>">
              <div class="hint mt-2">Kosongkan untuk menggunakan tanggal hari ini.</div>
            </div>

            <div style="margin:10px 0;">
  <label>
    <input type="checkbox" name="cek_kelulusan" value="1"
      <?= !empty($item['cek_kelulusan']) ? 'checked' : '' ?>>
    Tampilkan Form Cek Kelulusan di Pengumuman ini
  </label>
</div>

<div style="margin:10px 0;">
  <label>Tahun Kelulusan (opsional)</label><br>
  <input type="text" name="tahun_kelulusan" value="<?= esc($item['tahun_kelulusan'] ?? '') ?>"
         placeholder="contoh: 2025/2026" style="width:100%;padding:10px;">
</div>

            <!-- Status Publish -->
            <div class="form-group">
              <div class="checkbox-wrapper">
                <input type="checkbox" name="is_published" id="is_published" value="1"
                  <?= old('is_published', $item['is_published'] ?? 0) ? 'checked' : '' ?>>
                <label for="is_published">Publish berita ini (tampilkan di website publik)</label>
              </div>
            </div>

            <hr class="my-4">

            <!-- Buttons -->
            <div class="d-flex gap-2">
              <button type="submit" class="btn btn-primary">💾 Simpan Berita</button>
              <a href="<?= site_url('admin/pengumuman') ?>" class="btn btn-secondary">Batal</a>
            </div>
          </form>

        </div>
      </div>

      <div class="hint text-center mt-4">
        © <?= date('Y') ?> Admin Panel
      </div>

    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<!-- ===== TAMBAHAN JS (AMAN) ===== -->
<script>
function toggleSidebar(){
  document.getElementById('sidebar').classList.toggle('show');
  document.querySelector('.sidebar-overlay').classList.toggle('show');
}
</script>
</body>
</html>